/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.utils;

import com.annimon.stream.function.Supplier;
import com.google.common.base.Strings;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;

public class MD5Util {
    private static final String[] HEX_DIGITS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public static String getFileMD5(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        return (String)Supplier.Util.safe(() -> Files.asByteSource((File)file).hash(Hashing.md5()).toString(), (Object)"").get();
    }

    public static String getStringMD5(String src) {
        if (Strings.isNullOrEmpty((String)src)) {
            return null;
        }
        return (String)Supplier.Util.safe(() -> ByteSource.wrap((byte[])src.getBytes(Charset.forName("utf-8"))).hash(Hashing.md5()).toString(), (Object)"").get();
    }

    public static String byteArrayToHexString(byte[] digest) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            result.append(MD5Util.byteToHexString(digest[i]));
        }
        return result.toString();
    }

    public static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return HEX_DIGITS[d1] + HEX_DIGITS[d2];
    }

    public static byte[] stringToByte(String hexString) {
        int len = hexString.length() / 2;
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            result[i] = Integer.valueOf(hexString.substring(2 * i, 2 * i + 2), 16).byteValue();
        }
        return result;
    }
}

