/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.crash.compat;

import android.app.ActivityManager;
import android.content.Intent;
import android.os.IBinder;
import android.os.Message;
import com.fshows.android.stark.crash.compat.IActivityKiller;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ActivityKillerV26
implements IActivityKiller {
    @Override
    public void finishLaunchActivity(Message message) {
        try {
            Object activityClientRecord = message.obj;
            Field tokenField = activityClientRecord.getClass().getDeclaredField("token");
            tokenField.setAccessible(true);
            IBinder binder = (IBinder)tokenField.get(activityClientRecord);
            this.finish(binder);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void finishResumeActivity(Message message) {
        this.finishSomeArgs(message);
    }

    @Override
    public void finishPauseActivity(Message message) {
        this.finishSomeArgs(message);
    }

    @Override
    public void finishStopActivity(Message message) {
        this.finishSomeArgs(message);
    }

    private void finishSomeArgs(Message message) {
        try {
            Object someArgs = message.obj;
            Field arg1Field = someArgs.getClass().getDeclaredField("arg1");
            arg1Field.setAccessible(true);
            IBinder binder = (IBinder)arg1Field.get(someArgs);
            this.finish(binder);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void finish(IBinder binder) throws Exception {
        Method getServiceMethod = ActivityManager.class.getDeclaredMethod("getService", new Class[0]);
        Object activityManager = getServiceMethod.invoke(null, new Object[0]);
        Method finishActivityMethod = activityManager.getClass().getDeclaredMethod("finishActivity", IBinder.class, Integer.TYPE, Intent.class, Integer.TYPE);
        finishActivityMethod.setAccessible(true);
        int DONT_FINISH_TASK_WITH_ACTIVITY = 0;
        finishActivityMethod.invoke(activityManager, binder, 0, null, DONT_FINISH_TASK_WITH_ACTIVITY);
    }
}

