/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.compress;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.util.Log;
import com.fshows.android.stark.compress.CompressBuilder;
import com.fshows.android.stark.utils.BitmapUtil;
import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;

public class ImageCompress {
    private static final String TAG = ImageCompress.class.getSimpleName();
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    public static final int DEFAULT_PIC_WIDTH = 480;
    public static final int DEFAULT_PIC_HEIGHT = 800;
    public static final int DEFAULT_MAX_FILE_SIZE = 0x100000;
    public static final int DEFAULT_HIGH_QUALITY = 100;
    public static final int DEFAULT_LOW_QUALITY = 10;
    public static final boolean DEFAULT_IS_SIZE_COMPRESS = true;
    public static final boolean DEFAULT_IS_PIC = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File compressImage(String srcPath, CompressBuilder builder) throws Exception {
        if (Strings.isNullOrEmpty((String)srcPath)) {
            return null;
        }
        File srcFile = new File(srcPath);
        if (srcFile == null || !srcFile.exists()) {
            return null;
        }
        Log.e((String)TAG, (String)("compress before image size : " + srcFile.length() / 1024L));
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        try (FileInputStream inputStream = null;){
            inputStream = new FileInputStream(srcFile);
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }
        int actualHeight = options.outHeight;
        int actualWidth = options.outWidth;
        if (actualHeight == -1 || actualWidth == -1) {
            try {
                ExifInterface exifInterface = new ExifInterface(srcPath);
                actualHeight = exifInterface.getAttributeInt("ImageLength", 1);
                actualWidth = exifInterface.getAttributeInt("ImageWidth", 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (actualWidth <= 0 || actualHeight <= 0) {
            return null;
        }
        int maxWidth = builder.isSizeCompress() ? builder.getPicWidth() : actualWidth;
        int maxHeight = builder.isSizeCompress() ? builder.getPicHeight() : actualHeight;
        float imgRatio = (float)actualWidth / (float)actualHeight;
        float maxRatio = maxWidth / maxHeight;
        if (actualHeight > maxHeight || actualWidth > maxWidth) {
            if (imgRatio < maxRatio) {
                imgRatio = (float)maxHeight / (float)actualHeight;
                actualWidth = (int)(imgRatio * (float)actualWidth);
                actualHeight = maxHeight;
            } else if (imgRatio > maxRatio) {
                imgRatio = (float)maxWidth / (float)actualWidth;
                actualHeight = (int)(imgRatio * (float)actualHeight);
                actualWidth = maxWidth;
            } else {
                actualHeight = maxHeight;
                actualWidth = maxWidth;
            }
        }
        Log.e((String)TAG, (String)("image actual size: " + actualWidth + " , " + actualHeight));
        options.inSampleSize = BitmapUtil.calculateInSampleSize(options, actualWidth, actualHeight);
        options.inPreferredConfig = Bitmap.Config.RGB_565;
        options.inJustDecodeBounds = false;
        Log.e((String)TAG, (String)("image sample size: " + options.inSampleSize));
        Bitmap targetBitmap = null;
        try (FileInputStream inputStream2 = null;){
            inputStream2 = new FileInputStream(srcPath);
            targetBitmap = BitmapFactory.decodeStream((InputStream)inputStream2, null, (BitmapFactory.Options)options);
        }
        if (targetBitmap == null) {
            return null;
        }
        try {
            ExifInterface exif = new ExifInterface(srcPath);
            int orientation = exif.getAttributeInt("Orientation", 1);
            Matrix matrix = new Matrix();
            int degree = 0;
            if (orientation == 6) {
                degree = 90;
            } else if (orientation == 3) {
                degree = 180;
            } else if (orientation == 8) {
                degree = 270;
            }
            matrix.postRotate((float)degree);
            targetBitmap = Bitmap.createBitmap((Bitmap)targetBitmap, (int)0, (int)0, (int)targetBitmap.getWidth(), (int)targetBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (targetBitmap == null) {
            return null;
        }
        if (BitmapUtil.getBitmapSize(targetBitmap) > builder.getFileSize()) {
            targetBitmap = ImageCompress.compressImage(targetBitmap, builder);
        }
        if (targetBitmap == null) {
            return null;
        }
        File outDir = new File(builder.getDestDir());
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        File outFile = new File(outDir, srcFile.getName());
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outFile.getAbsolutePath());
            targetBitmap.compress(Bitmap.CompressFormat.JPEG, builder.getQuality(), (OutputStream)fileOutputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (targetBitmap != null) {
                targetBitmap.recycle();
            }
        }
        Log.e((String)TAG, (String)("final file size: " + outFile.length() / 1024L));
        return outFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap compressImage(Bitmap bitmap, CompressBuilder builder) {
        Bitmap bitmap2 = null;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            int quality = builder.getQuality();
            bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)outputStream);
            while (outputStream.toByteArray().length > builder.getFileSize() && quality > 10) {
                Log.e((String)TAG, (String)("compress image looping: " + quality));
                outputStream.reset();
                bitmap.compress(Bitmap.CompressFormat.JPEG, quality -= 10, (OutputStream)outputStream);
            }
            builder.setQuality(quality);
            byte[] bytes = outputStream.toByteArray();
            if (bytes == null || bytes.length <= 0) {
                return null;
            }
            try (ByteArrayInputStream input = null;){
                input = new ByteArrayInputStream(bytes);
                SoftReference<Bitmap> softRef = new SoftReference<Bitmap>(BitmapFactory.decodeStream((InputStream)input, null, null));
                bitmap2 = softRef.get();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitmap2;
    }
}

