/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.rogers.service;

import android.content.Context;
import android.util.Log;
import com.fshows.android.rogers.service.IPushService;
import com.huawei.hms.api.ConnectionResult;
import com.huawei.hms.api.HuaweiApiClient;
import com.huawei.hms.support.api.client.ApiClient;
import com.huawei.hms.support.api.client.PendingResult;
import com.huawei.hms.support.api.client.ResultCallback;
import com.huawei.hms.support.api.push.HuaweiPush;
import com.huawei.hms.support.api.push.TokenResult;

public class HuaWeiPushService
implements IPushService {
    private static final String TAG = HuaWeiPushService.class.getSimpleName();
    private static HuaweiApiClient mClient;

    public static IPushService getInstance(Context mContext) {
        mClient = new HuaweiApiClient.Builder(mContext).addApi(HuaweiPush.PUSH_API).addConnectionCallbacks(new HuaweiApiClient.ConnectionCallbacks(){

            public void onConnected() {
                Log.i((String)TAG, (String)"onConnected");
                PendingResult tokenResult = HuaweiPush.HuaweiPushApi.getToken((ApiClient)mClient);
                tokenResult.setResultCallback((ResultCallback)new ResultCallback<TokenResult>(){

                    public void onResult(TokenResult result) {
                        Log.i((String)TAG, (String)("result: " + result.toString()));
                    }
                });
            }

            public void onConnectionSuspended(int i) {
                Log.i((String)TAG, (String)("onConnectionSuspended: " + i));
            }
        }).addOnConnectionFailedListener(new HuaweiApiClient.OnConnectionFailedListener(){

            public void onConnectionFailed(ConnectionResult connectionResult) {
                Log.i((String)TAG, (String)("onConnectionFailed: " + connectionResult.getErrorCode()));
            }
        }).build();
        mClient.connect();
        Log.d((String)TAG, (String)"initializing huawei push....");
        return new HuaWeiPushService();
    }
}

