/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.rogers.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import cn.jpush.android.api.JPushInterface;
import com.fshows.android.rogers.manager.JPushManager;
import com.fshows.android.rogers.manager.PushChannel;
import com.fshows.android.rogers.mix.MixPushMessage;
import com.fshows.android.rogers.push.IPushChannel;
import org.json.JSONException;
import org.json.JSONObject;

public class JPushReceiver
extends BroadcastReceiver
implements IPushChannel {
    private static final String TAG = JPushReceiver.class.getSimpleName();

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        Bundle bundle = intent.getExtras();
        Log.e((String)TAG, (String)(action + "   \u6781\u5149onReceive----" + action));
        if (bundle == null) {
            bundle = new Bundle();
        }
        if ("cn.jpush.android.intent.REGISTRATION".equals(action)) {
            String token = bundle.getString("cn.jpush.android.REGISTRATION_ID");
            Log.e((String)TAG, (String)("ACTION_REGISTRATION_ID -> " + token));
        } else if ("cn.jpush.android.intent.NOTIFICATION_RECEIVED".equals(action)) {
            String message = bundle.getString("cn.jpush.android.MESSAGE");
            String extra = bundle.getString("cn.jpush.android.EXTRA");
            Log.e((String)TAG, (String)("messagecn.jpush.android.intent.MESSAGE_RECEIVED" + message));
            Log.e((String)TAG, (String)("extracn.jpush.android.intent.MESSAGE_RECEIVED" + extra));
            try {
                JSONObject object = new JSONObject(extra);
                JSONObject msgObject = object.getJSONObject("on_message");
                int passType = msgObject.getInt("pass_type");
                MixPushMessage mixPushMessage = new MixPushMessage(this.getPushName());
                if (passType == 1) {
                    mixPushMessage.setContent(extra);
                    JPushManager.sMixMessageProvider.onReceivePassThroughMessage(context, mixPushMessage);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else if (!"cn.jpush.android.intent.MESSAGE_RECEIVED".equals(action)) {
            if ("cn.jpush.android.intent.NOTIFICATION_OPENED".equals(action)) {
                String extra = bundle.getString("cn.jpush.android.EXTRA");
                try {
                    JSONObject object = new JSONObject(extra);
                    JSONObject msgObject = object.getJSONObject("on_message");
                    MixPushMessage mixPushMessage = new MixPushMessage(this.getPushName());
                    mixPushMessage.setMsgObject(msgObject.toString());
                    JPushManager.sMixMessageProvider.onNotificationMessageClicked(context, mixPushMessage);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else if ("cn.jpush.android.intent.CONNECTION".equals(action)) {
                String token = JPushInterface.getRegistrationID((Context)context);
                if (TextUtils.isEmpty((CharSequence)token)) {
                    return;
                }
                MixPushMessage mixPushMessage = new MixPushMessage(this.getPushName());
                mixPushMessage.setCid(token);
                JPushManager.sMixMessageProvider.onReceiveClientId(context, mixPushMessage);
            }
        }
    }

    @Override
    public String getPushName() {
        return PushChannel.jiguang.name();
    }
}

