/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.push.common.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import com.alibaba.sdk.android.push.common.util.support.NetworkInfo;

public class NetworkUtils {
    public static NetworkInfo.NetworkSP getNetworkSP(Context object) {
        NetworkInfo.NetworkSP networkSP = NetworkInfo.NetworkSP.UNKNOWN;
        if ((object = ((TelephonyManager)object.getSystemService("phone")).getSubscriberId()) == null) {
            return networkSP;
        }
        if (((String)object).startsWith("46000") || ((String)object).startsWith("46002")) {
            networkSP = NetworkInfo.NetworkSP.CHINA_MOBILE;
        } else if (((String)object).startsWith("46001")) {
            networkSP = NetworkInfo.NetworkSP.CHINA_UNICOM;
        } else if (((String)object).startsWith("46003")) {
            networkSP = NetworkInfo.NetworkSP.CHINA_TELECOM;
        }
        return networkSP;
    }

    public static boolean isNetworkAvailabe(Context context) {
        if ((context = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null) {
            return context.isAvailable();
        }
        return false;
    }

    public static boolean isUnknowNetwork(Context context) {
        return NetworkInfo.NetworkType.UNKNOWN.equals((Object)NetworkUtils.getNetworkType(context));
    }

    public static boolean is2G(Context context) {
        return NetworkInfo.NetworkType.G2.equals((Object)NetworkUtils.getNetworkType(context));
    }

    public static boolean isWifi(Context context) {
        return NetworkInfo.NetworkType.WIFI.equals((Object)NetworkUtils.getNetworkType(context));
    }

    public static boolean is3G(Context context) {
        return NetworkInfo.NetworkType.G3.equals((Object)NetworkUtils.getNetworkType(context));
    }

    public static boolean is4G(Context context) {
        return NetworkInfo.NetworkType.G4.equals((Object)NetworkUtils.getNetworkType(context));
    }

    public static NetworkInfo.NetworkType getNetworkType(Context context) {
        NetworkInfo networkInfo = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.getType() == 1) {
            return NetworkInfo.NetworkType.WIFI;
        }
        switch (((TelephonyManager)context.getSystemService("phone")).getNetworkType()) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return NetworkInfo.NetworkType.G2;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return NetworkInfo.NetworkType.G3;
            }
            case 13: {
                return NetworkInfo.NetworkType.G4;
            }
        }
        return NetworkInfo.NetworkType.UNKNOWN;
    }
}

