/*
 * Decompiled with CFR 0.152.
 */
package org.android.spdy;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.android.spdy.RequestPriority;

public final class SpdyRequest {
    public static final String GET_METHOD = "GET";
    public static final String POST_METHOD = "POST";
    private URL url;
    private String domain;
    private String host;
    private int port;
    private String proxyIp = "0.0.0.0";
    private int proxyPort = 0;
    private String method;
    private Map<String, String> extHead;
    private RequestPriority priority;
    private int requestTimeoutMs = 0;
    private int requestRdTimeoutMs = 0;
    private int connectionTimeoutMs = 0;
    private int retryTimes = 0;

    public SpdyRequest(URL uRL, String string, int n2, String string2, int n3, String string3, RequestPriority requestPriority, int n4, int n5, int n6) {
        this.url = uRL;
        this.domain = "";
        this.host = string;
        this.port = n2;
        if (string2 != null && n3 != 0) {
            this.proxyIp = string2;
            this.proxyPort = n3;
        }
        this.method = string3;
        this.extHead = new HashMap<String, String>(5);
        this.priority = requestPriority;
        if (requestPriority == null) {
            this.priority = RequestPriority.DEFAULT_PRIORITY;
        }
        this.requestTimeoutMs = n4;
        this.connectionTimeoutMs = n5;
        this.retryTimes = n6;
    }

    public SpdyRequest(URL uRL, String string, int n2, String string2, RequestPriority requestPriority) {
        this.url = uRL;
        this.domain = "";
        this.host = string;
        this.port = n2;
        this.method = string2;
        this.extHead = new HashMap<String, String>(5);
        this.priority = requestPriority;
        if (requestPriority == null) {
            this.priority = RequestPriority.DEFAULT_PRIORITY;
        }
    }

    public SpdyRequest(URL uRL, String string, RequestPriority requestPriority) {
        this.url = uRL;
        this.domain = "";
        this.host = uRL.getHost();
        this.port = uRL.getPort();
        if (this.port < 0) {
            this.port = uRL.getDefaultPort();
        }
        this.method = string;
        this.extHead = new HashMap<String, String>(5);
        this.priority = requestPriority;
        if (requestPriority == null) {
            this.priority = RequestPriority.DEFAULT_PRIORITY;
        }
    }

    public SpdyRequest(URL uRL, String string, RequestPriority requestPriority, int n2, int n3) {
        this.url = uRL;
        this.domain = "";
        this.host = uRL.getHost();
        this.port = uRL.getPort();
        if (this.port < 0) {
            this.port = uRL.getDefaultPort();
        }
        this.method = string;
        this.extHead = new HashMap<String, String>(5);
        this.priority = requestPriority;
        if (requestPriority == null) {
            this.priority = RequestPriority.DEFAULT_PRIORITY;
        }
        this.requestTimeoutMs = n2;
        this.connectionTimeoutMs = n3;
    }

    public SpdyRequest(URL uRL, String string) {
        this.url = uRL;
        this.domain = "";
        this.host = uRL.getHost();
        this.port = uRL.getPort();
        if (this.port < 0) {
            this.port = uRL.getDefaultPort();
        }
        this.method = string;
        this.extHead = new HashMap<String, String>(5);
        this.priority = RequestPriority.DEFAULT_PRIORITY;
    }

    public SpdyRequest(URL uRL, String string, String string2, int n2, String string3, int n3, String string4, RequestPriority requestPriority, int n4, int n5, int n6) {
        this.url = uRL;
        this.domain = string;
        this.host = string2;
        this.port = n2;
        if (string3 != null && n3 != 0) {
            this.proxyIp = string3;
            this.proxyPort = n3;
        }
        this.method = string4;
        this.extHead = new HashMap<String, String>(5);
        this.priority = requestPriority;
        if (requestPriority == null) {
            this.priority = RequestPriority.DEFAULT_PRIORITY;
        }
        this.requestTimeoutMs = n4;
        this.connectionTimeoutMs = n5;
        this.retryTimes = n6;
    }

    public SpdyRequest(URL uRL, String string, String string2, int n2, String string3, RequestPriority requestPriority) {
        this.url = uRL;
        this.domain = string;
        this.host = string2;
        this.port = n2;
        this.method = string3;
        this.extHead = new HashMap<String, String>(5);
        this.priority = requestPriority;
        if (requestPriority == null) {
            this.priority = RequestPriority.DEFAULT_PRIORITY;
        }
    }

    public SpdyRequest(URL uRL, String string, String string2, RequestPriority requestPriority) {
        this.url = uRL;
        this.domain = string;
        this.host = uRL.getHost();
        this.port = uRL.getPort();
        if (this.port < 0) {
            this.port = uRL.getDefaultPort();
        }
        this.method = string2;
        this.extHead = new HashMap<String, String>(5);
        this.priority = requestPriority;
        if (requestPriority == null) {
            this.priority = RequestPriority.DEFAULT_PRIORITY;
        }
    }

    public SpdyRequest(URL uRL, String string, String string2, RequestPriority requestPriority, int n2, int n3) {
        this.url = uRL;
        this.domain = string;
        this.host = uRL.getHost();
        this.port = uRL.getPort();
        if (this.port < 0) {
            this.port = uRL.getDefaultPort();
        }
        this.method = string2;
        this.extHead = new HashMap<String, String>(5);
        this.priority = requestPriority;
        if (requestPriority == null) {
            this.priority = RequestPriority.DEFAULT_PRIORITY;
        }
        this.requestTimeoutMs = n2;
        this.connectionTimeoutMs = n3;
    }

    public SpdyRequest(URL uRL, String string, String string2) {
        this.url = uRL;
        this.domain = string;
        this.host = uRL.getHost();
        this.port = uRL.getPort();
        if (this.port < 0) {
            this.port = uRL.getDefaultPort();
        }
        this.method = string2;
        this.extHead = new HashMap<String, String>(5);
        this.priority = RequestPriority.DEFAULT_PRIORITY;
    }

    public final void setRequestRdTimeoutMs(int n2) {
        if (n2 >= 0) {
            this.requestRdTimeoutMs = n2;
        }
    }

    public final void addHeader(String string, String string2) {
        this.extHead.put(string, string2);
    }

    public final void addHeaders(Map<String, String> map) {
        this.extHead.putAll(map);
    }

    final URL getUrl() {
        return this.url;
    }

    final String getMethod() {
        return this.method;
    }

    final int getPriority() {
        return this.priority.getPriorityInt();
    }

    private String getPath() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.url.getPath());
        if (this.url.getQuery() != null) {
            stringBuilder.append("?").append(this.url.getQuery());
        }
        if (this.url.getRef() != null) {
            stringBuilder.append("#").append(this.url.getRef());
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }

    final Map<String, String> getHeaders() {
        HashMap<String, String> hashMap = new HashMap<String, String>(5);
        hashMap.put(":path", this.getPath());
        hashMap.put(":method", this.method);
        hashMap.put(":version", "HTTP/1.1");
        hashMap.put(":host", this.url.getAuthority());
        hashMap.put(":scheme", this.url.getProtocol());
        if (this.extHead != null && this.extHead.size() > 0) {
            hashMap.putAll(this.extHead);
        }
        return hashMap;
    }

    final String getUrlPath() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.url.getProtocol()).append("://").append(this.url.getAuthority()).append(this.getPath());
        return stringBuilder.toString();
    }

    final String getHost() {
        return this.host;
    }

    final int getPort() {
        if (this.port < 0) {
            return 80;
        }
        return this.port;
    }

    final String getProxyIp() {
        return this.proxyIp;
    }

    final int getProxyPort() {
        return this.proxyPort;
    }

    public final void setDomain(String string) {
        this.domain = string;
    }

    final String getDomain() {
        return this.domain;
    }

    public final String getAuthority() {
        return this.host + ":" + Integer.toString(this.port) + "/" + this.proxyIp + ":" + this.proxyPort;
    }

    public final int getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public final int getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public final int getRequestRdTimeoutMs() {
        return this.requestRdTimeoutMs;
    }

    public final int getRetryTimes() {
        return this.retryTimes;
    }
}

