/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.parker.navigation;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.viewpager.widget.ViewPager;
import com.fshows.android.parker.R;
import com.fshows.android.parker.navigation.BottomBarItem;
import java.util.ArrayList;
import java.util.List;

public class BottomBarLayout
extends LinearLayout
implements ViewPager.OnPageChangeListener {
    private static final String STATE_INSTANCE = "instance_state";
    private static final String STATE_ITEM = "state_item";
    private ViewPager mViewPager;
    private int mChildCount;
    private List<BottomBarItem> mItemViews = new ArrayList<BottomBarItem>();
    private int mCurrentItem;
    private boolean mSmoothScroll;
    private OnItemSelectedListener onItemSelectedListener;

    public BottomBarLayout(Context context) {
        this(context, null);
    }

    public BottomBarLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BottomBarLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.BottomBarLayout);
        this.mSmoothScroll = ta.getBoolean(R.styleable.BottomBarLayout_smoothScroll, false);
        ta.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.init();
    }

    public void setOrientation(int orientation) {
        super.setOrientation(orientation);
    }

    public void setViewPager(ViewPager viewPager) {
        this.mViewPager = viewPager;
        this.init();
    }

    private void init() {
        this.mItemViews.clear();
        this.mChildCount = this.getChildCount();
        if (this.mChildCount == 0) {
            return;
        }
        if (this.mViewPager != null && this.mViewPager.getAdapter().getCount() != this.mChildCount) {
            throw new IllegalArgumentException("LinearLayout\u7684\u5b50View\u6570\u91cf\u5fc5\u987b\u548cViewPager\u6761\u76ee\u6570\u91cf\u4e00\u81f4");
        }
        for (int i = 0; i < this.mChildCount; ++i) {
            if (!(this.getChildAt(i) instanceof BottomBarItem)) {
                throw new IllegalArgumentException("BottomBarLayout\u7684\u5b50View\u5fc5\u987b\u662fBottomBarItem");
            }
            BottomBarItem bottomBarItem = (BottomBarItem)this.getChildAt(i);
            this.mItemViews.add(bottomBarItem);
            bottomBarItem.setOnClickListener(new BottomBarItemClickListener(i));
        }
        if (this.mCurrentItem < this.mItemViews.size()) {
            this.mItemViews.get(this.mCurrentItem).refreshTab(true);
        }
        if (this.mViewPager != null) {
            this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        }
    }

    public void addItem(BottomBarItem item) {
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        layoutParams.weight = 1.0f;
        item.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.addView((View)item);
        this.init();
    }

    public void removeItem(int position) {
        BottomBarItem item;
        if (position >= 0 && position < this.mItemViews.size() && this.mItemViews.contains((Object)(item = this.mItemViews.get(position)))) {
            this.resetState();
            this.removeViewAt(position);
            this.init();
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        this.resetState();
        this.mItemViews.get(position).refreshTab(true);
        if (this.onItemSelectedListener != null) {
            this.onItemSelectedListener.onItemSelected(this.getBottomItem(position), this.mCurrentItem, position);
        }
        this.mCurrentItem = position;
    }

    public void onPageScrollStateChanged(int state) {
    }

    private void updateTabState(int position) {
        this.resetState();
        this.mCurrentItem = position;
        this.mItemViews.get(this.mCurrentItem).refreshTab(true);
    }

    private void resetState() {
        if (this.mCurrentItem < this.mItemViews.size()) {
            this.mItemViews.get(this.mCurrentItem).refreshTab(false);
        }
    }

    public void setCurrentItem(int currentItem) {
        if (this.mViewPager != null) {
            this.mViewPager.setCurrentItem(currentItem, this.mSmoothScroll);
        } else {
            if (this.onItemSelectedListener != null) {
                this.onItemSelectedListener.onItemSelected(this.getBottomItem(currentItem), this.mCurrentItem, currentItem);
            }
            this.updateTabState(currentItem);
        }
    }

    public void setUnread(int position, int unreadNum) {
        this.mItemViews.get(position).setUnreadNum(unreadNum);
    }

    public int getCurrentItem() {
        return this.mCurrentItem;
    }

    public void setSmoothScroll(boolean smoothScroll) {
        this.mSmoothScroll = smoothScroll;
    }

    public BottomBarItem getBottomItem(int position) {
        return this.mItemViews.get(position);
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(STATE_INSTANCE, super.onSaveInstanceState());
        bundle.putInt(STATE_ITEM, this.mCurrentItem);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mCurrentItem = bundle.getInt(STATE_ITEM);
            this.resetState();
            this.mItemViews.get(this.mCurrentItem).refreshTab(true);
            super.onRestoreInstanceState(bundle.getParcelable(STATE_INSTANCE));
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    public void setOnItemSelectedListener(OnItemSelectedListener onItemSelectedListener) {
        this.onItemSelectedListener = onItemSelectedListener;
    }

    public static interface OnItemSelectedListener {
        public void onItemSelected(BottomBarItem var1, int var2, int var3);
    }

    private class BottomBarItemClickListener
    implements View.OnClickListener {
        private int currentIndex;

        public BottomBarItemClickListener(int i) {
            this.currentIndex = i;
        }

        public void onClick(View v) {
            if (BottomBarLayout.this.mViewPager != null) {
                if (this.currentIndex == BottomBarLayout.this.mCurrentItem) {
                    if (BottomBarLayout.this.onItemSelectedListener != null) {
                        BottomBarLayout.this.onItemSelectedListener.onItemSelected(BottomBarLayout.this.getBottomItem(this.currentIndex), BottomBarLayout.this.mCurrentItem, this.currentIndex);
                    }
                } else {
                    BottomBarLayout.this.mViewPager.setCurrentItem(this.currentIndex, BottomBarLayout.this.mSmoothScroll);
                }
            } else {
                if (BottomBarLayout.this.onItemSelectedListener != null) {
                    BottomBarLayout.this.onItemSelectedListener.onItemSelected(BottomBarLayout.this.getBottomItem(this.currentIndex), BottomBarLayout.this.mCurrentItem, this.currentIndex);
                }
                BottomBarLayout.this.updateTabState(this.currentIndex);
            }
        }
    }
}

