/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.parker.recyclerview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.fshows.android.parker.R;
import com.fshows.android.parker.recyclerview.FsRecyclerView;
import com.fshows.android.parker.recyclerview.adapter.BaseBindingRecyclerViewAdapter;
import com.fshows.android.parker.recyclerview.adapter.BaseRecyclerViewAdapter;
import com.fshows.android.parker.recyclerview.adapter.WrapAdapter;

public class CommonDefaultDecoration
extends RecyclerView.ItemDecoration {
    public static final int HORIZONTAL_LIST = 0;
    public static final int VERTICAL_LIST = 1;
    private Drawable mDivider;
    private int mOrientation;
    private int insetLeft;
    private int insetRight;
    private Paint paint;

    public CommonDefaultDecoration(Context context, int orientation) {
        this(context, orientation, R.drawable.bg_item_decoration_new, 0, 0);
    }

    public CommonDefaultDecoration(Context context, int orientation, int insetLeft, int insetRight) {
        this.mDivider = ContextCompat.getDrawable((Context)context, (int)R.drawable.bg_item_decoration_new);
        this.insetLeft = insetLeft;
        this.insetRight = insetRight;
        this.paint = new Paint();
        this.paint.setColor(ContextCompat.getColor((Context)context, (int)R.color.common_white));
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setAntiAlias(true);
        this.setOrientation(orientation);
    }

    public CommonDefaultDecoration(Context context, int orientation, int drawable2, int insetLeft, int insetRight) {
        this.mDivider = ContextCompat.getDrawable((Context)context, (int)drawable2);
        this.insetLeft = insetLeft;
        this.insetRight = insetRight;
        this.paint = new Paint();
        this.paint.setColor(ContextCompat.getColor((Context)context, (int)R.color.common_white));
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setAntiAlias(true);
        this.setOrientation(orientation);
    }

    public CommonDefaultDecoration(Context context, int orientation, int drawable2, int insetLeft, int insetRight, int blockColor) {
        this.mDivider = ContextCompat.getDrawable((Context)context, (int)drawable2);
        this.insetLeft = insetLeft;
        this.insetRight = insetRight;
        this.paint = new Paint();
        this.paint.setColor(ContextCompat.getColor((Context)context, (int)blockColor));
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setAntiAlias(true);
        this.setOrientation(orientation);
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("invalid orientation");
        }
        this.mOrientation = orientation;
    }

    public void onDraw(@NonNull Canvas c, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        if (this.mOrientation == 1) {
            this.drawVertical(c, parent);
        } else {
            this.drawHorizontal(c, parent);
        }
    }

    private void drawVertical(Canvas c, RecyclerView parent) {
        int left = parent.getPaddingLeft();
        int right = parent.getWidth() - parent.getPaddingRight();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount - 1; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int top = child.getBottom() + params.bottomMargin;
            int bottom = top + this.mDivider.getIntrinsicHeight();
            if (!this.isDrawDivider(parent, child)) continue;
            if (this.insetLeft > 0 || this.insetRight > 0) {
                c.drawRect((float)left, (float)top, (float)right, (float)bottom, this.paint);
                this.mDivider.setBounds(left + this.insetLeft, top, right - this.insetRight, bottom);
            } else {
                this.mDivider.setBounds(left, top, right, bottom);
            }
            this.mDivider.draw(c);
        }
    }

    private boolean isDrawDivider(RecyclerView parent, View view) {
        if (parent instanceof FsRecyclerView) {
            WrapAdapter wrapAdapter = (WrapAdapter)parent.getAdapter();
            if (wrapAdapter == null) {
                return false;
            }
            int index = parent.getChildAdapterPosition(view);
            if (wrapAdapter.isHeader(index) || wrapAdapter.isFooter(index)) {
                return false;
            }
            RecyclerView.Adapter mAdapter = wrapAdapter.getAdapter();
            int position = index - wrapAdapter.getHeadersCount();
            if (position == mAdapter.getItemCount() - 1) {
                return false;
            }
            if (mAdapter instanceof BaseRecyclerViewAdapter && parent.getChildCount() > 0) {
                return !((BaseRecyclerViewAdapter)mAdapter).isPinnedPosition(position);
            }
            if (mAdapter instanceof BaseBindingRecyclerViewAdapter && parent.getChildCount() > 0) {
                return !((BaseBindingRecyclerViewAdapter)mAdapter).isPinnedPosition(position);
            }
        }
        return true;
    }

    private void drawHorizontal(Canvas c, RecyclerView parent) {
        int top = parent.getPaddingTop();
        int bottom = parent.getHeight() - parent.getPaddingBottom();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount - 1; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int left = child.getRight() + params.rightMargin;
            int right = left + this.mDivider.getIntrinsicHeight();
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(c);
        }
    }

    public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        if (this.mOrientation == 1) {
            if (this.isDrawDivider(parent, view)) {
                outRect.set(0, 0, 0, this.mDivider.getIntrinsicHeight());
            }
        } else {
            outRect.set(0, 0, this.mDivider.getIntrinsicWidth(), 0);
        }
    }
}

