/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsvideo;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.AudioManager;
import android.net.Uri;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.fshows.fsvideo.AndroidMediaPlayer;
import com.fshows.fsvideo.FsTextureView;
import com.fshows.fsvideo.FsVideoPlayerManager;
import com.fshows.fsvideo.FsVideoUtils;
import com.fshows.fsvideo.IFsVideoPlayer;
import com.fshows.fsvideo.IFsVideoPlayerController;
import com.fshows.fsvideo.IMediaPlayer;
import java.io.IOException;
import java.util.Map;

public class FsVideoPlayer
extends FrameLayout
implements IFsVideoPlayer,
TextureView.SurfaceTextureListener {
    private static final String TAG = "FsVideoPlayer";
    public static final int STATE_ERROR = -1;
    public static final int STATE_IDLE = 0;
    public static final int STATE_PREPARING = 1;
    public static final int STATE_PREPARED = 2;
    public static final int STATE_PLAYING = 3;
    public static final int STATE_PAUSED = 4;
    public static final int STATE_BUFFERING_PLAYING = 5;
    public static final int STATE_BUFFERING_PAUSED = 6;
    public static final int STATE_COMPLETED = 7;
    public static final int MODE_NORMAL = 10;
    public static final int MODE_FULL_SCREEN = 11;
    public static final int TYPE_IJK = 111;
    public static final int TYPE_NATIVE = 222;
    private int mPlayerType = 222;
    private int mCurrentState = 0;
    private int mCurrentMode = 10;
    private Context mContext;
    private FrameLayout mContainer;
    private String mUrl;
    private Map<String, String> mHeaders;
    private AudioManager mAudioManager;
    private IMediaPlayer mMediaPlayer;
    private IFsVideoPlayerController mController;
    private FsTextureView mTextureView;
    private long skipToPosition;
    private boolean continueFromLastPosition = true;
    private int mBufferPercentage;
    private Surface mSurface;
    private SurfaceTexture mSurfaceTexture;
    private boolean isCanLandscape = true;
    private IMediaPlayer.OnPreparedListener mOnPreparedListener = new IMediaPlayer.OnPreparedListener(){

        @Override
        public void onPrepared(IMediaPlayer mp) {
            FsVideoPlayer.this.mCurrentState = 2;
            FsVideoPlayer.this.mController.onPlayStateChanged(FsVideoPlayer.this.mCurrentState);
            Log.d((String)FsVideoPlayer.TAG, (String)"onPrepared \u2014\u2014> STATE_PREPARED");
            mp.start();
            if (FsVideoPlayer.this.continueFromLastPosition) {
                long savedPlayPosition = FsVideoUtils.getSavedPlayPosition(FsVideoPlayer.this.mContext, FsVideoPlayer.this.mUrl);
                mp.seekTo(savedPlayPosition);
            }
            if (FsVideoPlayer.this.skipToPosition != 0L) {
                mp.seekTo(FsVideoPlayer.this.skipToPosition);
            }
        }
    };
    private IMediaPlayer.OnVideoSizeChangedListener mOnVideoSizeChangedListener = new IMediaPlayer.OnVideoSizeChangedListener(){

        @Override
        public void onVideoSizeChanged(IMediaPlayer mp, int width, int height, int sar_num, int sar_den) {
            FsVideoPlayer.this.mTextureView.adaptVideoSize(width, height);
            Log.d((String)FsVideoPlayer.TAG, (String)("onVideoSizeChanged \u2014\u2014> width\uff1a" + width + "\uff0c height\uff1a" + height));
        }
    };
    private IMediaPlayer.OnCompletionListener mOnCompletionListener = new IMediaPlayer.OnCompletionListener(){

        @Override
        public void onCompletion(IMediaPlayer mp) {
            FsVideoPlayer.this.mCurrentState = 7;
            FsVideoPlayer.this.mController.onPlayStateChanged(FsVideoPlayer.this.mCurrentState);
            Log.d((String)FsVideoPlayer.TAG, (String)"onCompletion \u2014\u2014> STATE_COMPLETED");
            FsVideoPlayer.this.mContainer.setKeepScreenOn(false);
        }
    };
    private IMediaPlayer.OnErrorListener mOnErrorListener = new IMediaPlayer.OnErrorListener(){

        @Override
        public boolean onError(IMediaPlayer mp, int what, int extra) {
            if (what != -38 && what != Integer.MIN_VALUE && extra != -38 && extra != Integer.MIN_VALUE) {
                FsVideoPlayer.this.mCurrentState = -1;
                FsVideoPlayer.this.mController.onPlayStateChanged(FsVideoPlayer.this.mCurrentState);
                Log.d((String)FsVideoPlayer.TAG, (String)("onError \u2014\u2014> STATE_ERROR \u2014\u2014\u2014\u2014 what\uff1a" + what + ", extra: " + extra));
            }
            return true;
        }
    };
    private IMediaPlayer.OnInfoListener mOnInfoListener = new IMediaPlayer.OnInfoListener(){

        @Override
        public boolean onInfo(IMediaPlayer mp, int what, int extra) {
            if (what == 3) {
                FsVideoPlayer.this.mCurrentState = 3;
                FsVideoPlayer.this.mController.onPlayStateChanged(FsVideoPlayer.this.mCurrentState);
                Log.d((String)FsVideoPlayer.TAG, (String)"onInfo \u2014\u2014> MEDIA_INFO_VIDEO_RENDERING_START\uff1aSTATE_PLAYING");
            } else if (what == 701) {
                if (FsVideoPlayer.this.mCurrentState == 4 || FsVideoPlayer.this.mCurrentState == 6) {
                    FsVideoPlayer.this.mCurrentState = 6;
                    Log.d((String)FsVideoPlayer.TAG, (String)"onInfo \u2014\u2014> MEDIA_INFO_BUFFERING_START\uff1aSTATE_BUFFERING_PAUSED");
                } else {
                    FsVideoPlayer.this.mCurrentState = 5;
                    Log.d((String)FsVideoPlayer.TAG, (String)"onInfo \u2014\u2014> MEDIA_INFO_BUFFERING_START\uff1aSTATE_BUFFERING_PLAYING");
                }
                FsVideoPlayer.this.mController.onPlayStateChanged(FsVideoPlayer.this.mCurrentState);
            } else if (what == 702) {
                if (FsVideoPlayer.this.mCurrentState == 5) {
                    FsVideoPlayer.this.mCurrentState = 3;
                    FsVideoPlayer.this.mController.onPlayStateChanged(FsVideoPlayer.this.mCurrentState);
                    Log.d((String)FsVideoPlayer.TAG, (String)"onInfo \u2014\u2014> MEDIA_INFO_BUFFERING_END\uff1a STATE_PLAYING");
                }
                if (FsVideoPlayer.this.mCurrentState == 6) {
                    FsVideoPlayer.this.mCurrentState = 4;
                    FsVideoPlayer.this.mController.onPlayStateChanged(FsVideoPlayer.this.mCurrentState);
                    Log.d((String)FsVideoPlayer.TAG, (String)"onInfo \u2014\u2014> MEDIA_INFO_BUFFERING_END\uff1a STATE_PAUSED");
                }
            } else if (what == 10001) {
                if (FsVideoPlayer.this.mTextureView != null) {
                    FsVideoPlayer.this.mTextureView.setRotation(extra);
                    Log.d((String)FsVideoPlayer.TAG, (String)("\u89c6\u9891\u65cb\u8f6c\u89d2\u5ea6\uff1a" + extra));
                }
            } else if (what == 801) {
                Log.d((String)FsVideoPlayer.TAG, (String)"\u89c6\u9891\u4e0d\u80fdseekTo\uff0c\u4e3a\u76f4\u64ad\u89c6\u9891");
            } else {
                Log.d((String)FsVideoPlayer.TAG, (String)("onInfo \u2014\u2014> what\uff1a" + what));
            }
            return true;
        }
    };
    private IMediaPlayer.OnBufferingUpdateListener mOnBufferingUpdateListener = new IMediaPlayer.OnBufferingUpdateListener(){

        @Override
        public void onBufferingUpdate(IMediaPlayer mp, int percent) {
            FsVideoPlayer.this.mBufferPercentage = percent;
        }
    };

    public FsVideoPlayer(Context context) {
        super(context, null);
    }

    public FsVideoPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.init();
    }

    private void init() {
        this.mContainer = new FrameLayout(this.mContext);
        this.mContainer.setBackgroundColor(-16777216);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        this.addView((View)this.mContainer, (ViewGroup.LayoutParams)params);
    }

    public void setPlayerType(int playerType) {
        this.mPlayerType = playerType;
    }

    public void setCanLandscape(boolean canLandscape) {
        this.isCanLandscape = canLandscape;
    }

    public void setController(IFsVideoPlayerController controller) {
        this.mContainer.removeView((View)this.mController);
        this.mController = controller;
        this.mController.reset();
        this.mController.setIFsVideoPlayer(this);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        this.mContainer.addView((View)this.mController, (ViewGroup.LayoutParams)params);
    }

    @Override
    public void setPlayUrl(String url, Map<String, String> headers) {
        this.mUrl = url;
        this.mHeaders = headers;
    }

    @Override
    public void start() {
        if (this.mCurrentState == 0) {
            FsVideoPlayerManager.instance().setVideoPlayer(this);
            this.initAudioManager();
            this.initMediaPlayer();
            this.initTextureView();
            this.addTextureView();
        } else {
            Log.d((String)TAG, (String)"FsVideoPlayer\u53ea\u6709\u5728mCurrentState == STATE_IDLE\u65f6\u624d\u80fd\u8c03\u7528start\u65b9\u6cd5.");
        }
    }

    private void addTextureView() {
        this.mContainer.removeView((View)this.mTextureView);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1, 17);
        this.mContainer.addView((View)this.mTextureView, 0, (ViewGroup.LayoutParams)params);
    }

    private void initTextureView() {
        if (this.mTextureView == null) {
            this.mTextureView = new FsTextureView(this.mContext);
            this.mTextureView.setSurfaceTextureListener(this);
        }
    }

    private void initMediaPlayer() {
        if (this.mMediaPlayer == null) {
            this.mMediaPlayer = new AndroidMediaPlayer();
            this.mMediaPlayer.setAudioStreamType(3);
        }
    }

    private void initAudioManager() {
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
            this.mAudioManager.requestAudioFocus(null, 3, 1);
        }
    }

    @Override
    public void start(long position) {
        this.skipToPosition = position;
        this.start();
    }

    @Override
    public void reStart() {
        if (this.mCurrentState == 4) {
            this.mMediaPlayer.start();
            this.mCurrentState = 3;
            this.mController.onPlayStateChanged(this.mCurrentState);
            Log.d((String)TAG, (String)"STATE_PLAYING");
        } else if (this.mCurrentState == 6) {
            this.mMediaPlayer.start();
            this.mCurrentState = 3;
            this.mController.onPlayStateChanged(this.mCurrentState);
            Log.d((String)TAG, (String)"STATE_PLAYING");
        } else if (this.mCurrentState == 7 || this.mCurrentState == -1) {
            this.mMediaPlayer.reset();
            this.openMediaPlayer();
        }
    }

    private void openMediaPlayer() {
        this.mContainer.setKeepScreenOn(true);
        this.mMediaPlayer.setOnPreparedListener(this.mOnPreparedListener);
        this.mMediaPlayer.setOnVideoSizeChangedListener(this.mOnVideoSizeChangedListener);
        this.mMediaPlayer.setOnCompletionListener(this.mOnCompletionListener);
        this.mMediaPlayer.setOnErrorListener(this.mOnErrorListener);
        this.mMediaPlayer.setOnInfoListener(this.mOnInfoListener);
        this.mMediaPlayer.setOnBufferingUpdateListener(this.mOnBufferingUpdateListener);
        try {
            this.mMediaPlayer.setDataSource(this.mContext.getApplicationContext(), Uri.parse((String)this.mUrl), this.mHeaders);
            if (this.mSurface == null) {
                this.mSurface = new Surface(this.mSurfaceTexture);
            }
            this.mMediaPlayer.setSurface(this.mSurface);
            this.mMediaPlayer.prepareAsync();
            this.mCurrentState = 1;
            this.mController.onPlayStateChanged(this.mCurrentState);
            Log.d((String)TAG, (String)"STATE_PREPARING");
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.d((String)TAG, (String)"\u6253\u5f00\u64ad\u653e\u5668\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    @Override
    public void pause() {
        if (this.mCurrentState == 3) {
            this.mMediaPlayer.pause();
            this.mCurrentState = 4;
            this.mController.onPlayStateChanged(this.mCurrentState);
            Log.d((String)TAG, (String)"STATE_PAUSED");
        }
        if (this.mCurrentState == 5) {
            this.mMediaPlayer.pause();
            this.mCurrentState = 6;
            this.mController.onPlayStateChanged(this.mCurrentState);
            Log.d((String)TAG, (String)"STATE_BUFFERING_PAUSED");
        }
    }

    @Override
    public void seekTo(long position) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.seekTo(position);
        }
    }

    @Override
    public void setVolume(int volume) {
        if (this.mAudioManager != null) {
            this.mAudioManager.setStreamVolume(3, volume, 0);
        }
    }

    @Override
    public void isPlayFromLastPosition(boolean isPlayFromLast) {
        this.continueFromLastPosition = isPlayFromLast;
    }

    @Override
    public int getMaxVolume() {
        if (this.mAudioManager != null) {
            return this.mAudioManager.getStreamMaxVolume(3);
        }
        return 0;
    }

    @Override
    public long getCurrentPosition() {
        return this.mMediaPlayer != null ? this.mMediaPlayer.getCurrentPosition() : 0L;
    }

    @Override
    public int getBufferPercentage() {
        return this.mBufferPercentage;
    }

    @Override
    public int getVolume() {
        if (this.mAudioManager != null) {
            return this.mAudioManager.getStreamVolume(3);
        }
        return 0;
    }

    @Override
    public long getDuration() {
        return this.mMediaPlayer != null ? this.mMediaPlayer.getDuration() : 0L;
    }

    @Override
    public void enterFullScreen() {
        if (this.mCurrentState == 11) {
            return;
        }
        FsVideoUtils.hideActionBar(this.mContext);
        if (this.isCanLandscape) {
            FsVideoUtils.scanForActivity(this.mContext).setRequestedOrientation(0);
        }
        ViewGroup contentView = (ViewGroup)FsVideoUtils.scanForActivity(this.mContext).findViewById(0x1020002);
        this.removeView((View)this.mContainer);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        contentView.addView((View)this.mContainer, (ViewGroup.LayoutParams)params);
        this.mCurrentMode = 11;
        this.mController.onPlayModeChanged(this.mCurrentMode);
        Log.d((String)TAG, (String)"MODE_FULL_SCREEN");
    }

    @Override
    public boolean exitFullScreen() {
        if (this.mCurrentMode == 11) {
            FsVideoUtils.showActionBar(this.mContext);
            FsVideoUtils.scanForActivity(this.mContext).setRequestedOrientation(1);
            ViewGroup contentView = (ViewGroup)FsVideoUtils.scanForActivity(this.mContext).findViewById(0x1020002);
            contentView.removeView((View)this.mContainer);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
            this.addView((View)this.mContainer, (ViewGroup.LayoutParams)params);
            this.mCurrentMode = 10;
            this.mController.onPlayModeChanged(this.mCurrentMode);
            Log.d((String)TAG, (String)"MODE_NORMAL");
            return true;
        }
        return false;
    }

    @Override
    public void releasePlayer() {
        if (this.mAudioManager != null) {
            this.mAudioManager.abandonAudioFocus(null);
            this.mAudioManager = null;
        }
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
        this.mContainer.removeView((View)this.mTextureView);
        if (this.mSurface != null) {
            this.mSurface.release();
            this.mSurface = null;
        }
        if (this.mSurfaceTexture != null) {
            this.mSurfaceTexture.release();
            this.mSurfaceTexture = null;
        }
        this.mCurrentState = 0;
    }

    @Override
    public void release() {
        if (this.mCurrentState == 3 || this.mCurrentState == 5 || this.mCurrentState == 6 || this.mCurrentState == 4) {
            FsVideoUtils.savePlayPosition(this.mContext, this.mUrl, this.getCurrentPosition());
        } else if (this.mCurrentState == 7) {
            FsVideoUtils.savePlayPosition(this.mContext, this.mUrl, 0L);
        }
        if (this.isFullScreen()) {
            this.exitFullScreen();
        }
        this.mCurrentMode = 10;
        this.releasePlayer();
        if (this.mController != null) {
            this.mController.reset();
        }
        Runtime.getRuntime().gc();
    }

    @Override
    public boolean isFullScreen() {
        return this.mCurrentMode == 11;
    }

    @Override
    public boolean isNormal() {
        return this.mCurrentMode == 10;
    }

    @Override
    public int getPlayState() {
        return this.mCurrentState;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
        if (this.mSurfaceTexture == null) {
            this.mSurfaceTexture = surfaceTexture;
            this.openMediaPlayer();
        } else {
            this.mTextureView.setSurfaceTexture(this.mSurfaceTexture);
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int i, int i1) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        return this.mSurfaceTexture == null;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }

    public boolean isPaused() {
        return this.getPlayState() == 4;
    }
}

