/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsvideo;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import com.fshows.fsvideo.IFsVideoPlayer;
import com.fshows.fsvideo.utils.FsVideoUtils;
import java.util.Timer;
import java.util.TimerTask;

public abstract class IFsVideoPlayerController
extends FrameLayout
implements View.OnTouchListener {
    private Context mContext;
    protected IFsVideoPlayer mIFsVideoPlayer;
    private Timer mUpdateProgressTimer;
    private TimerTask mUpdateProgressTimerTask;
    private float mDownX;
    private float mDownY;
    private boolean mNeedChangePosition;
    private boolean mNeedChangeVolume;
    private boolean mNeedChangeBrightness;
    private static final int THRESHOLD = 80;
    private long mGestureDownPosition;
    private float mGestureDownBrightness;
    private int mGestureDownVolume;
    private long mNewPosition;

    public IFsVideoPlayerController(@NonNull Context context) {
        super(context);
        this.mContext = context;
        this.setOnTouchListener(this);
    }

    public void setIFsVideoPlayer(IFsVideoPlayer iFsVideoPlayer) {
        this.mIFsVideoPlayer = iFsVideoPlayer;
    }

    public abstract void setTitle(String var1);

    public abstract void setStartImage(@DrawableRes int var1);

    public abstract ImageView imageView();

    public abstract void setLength(int var1);

    protected abstract void onPlayStateChanged(int var1);

    protected abstract void onPlayModeChanged(int var1);

    protected abstract void reset();

    protected void startUpdateProgressTimer() {
        this.cancelUpdateProgressTimer();
        if (this.mUpdateProgressTimer == null) {
            this.mUpdateProgressTimer = new Timer();
        }
        if (this.mUpdateProgressTimerTask == null) {
            this.mUpdateProgressTimerTask = new TimerTask(){

                @Override
                public void run() {
                    IFsVideoPlayerController.this.post(() -> IFsVideoPlayerController.this.updateProgress());
                }
            };
        }
        this.mUpdateProgressTimer.schedule(this.mUpdateProgressTimerTask, 0L, 1000L);
    }

    protected void cancelUpdateProgressTimer() {
        if (this.mUpdateProgressTimerTask != null) {
            this.mUpdateProgressTimerTask.cancel();
            this.mUpdateProgressTimerTask = null;
        }
        if (this.mUpdateProgressTimer != null) {
            this.mUpdateProgressTimer.cancel();
            this.mUpdateProgressTimer = null;
        }
    }

    protected abstract void updateProgress();

    public boolean onTouch(View view, MotionEvent motionEvent) {
        if (!this.mIFsVideoPlayer.isFullScreen()) {
            return false;
        }
        switch (this.mIFsVideoPlayer.getPlayState()) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 7: {
                this.hideChangePosition();
                this.hideChangeBrightness();
                this.hideChangeVolume();
                return false;
            }
        }
        float x = motionEvent.getX();
        float y = motionEvent.getY();
        switch (motionEvent.getAction()) {
            case 0: {
                this.mDownX = x;
                this.mDownY = y;
                this.mNeedChangeBrightness = false;
                this.mNeedChangePosition = false;
                this.mNeedChangeVolume = false;
                break;
            }
            case 2: {
                float deltaX = x - this.mDownX;
                float deltaY = y - this.mDownY;
                float absDeltaX = Math.abs(deltaX);
                float absDeltaY = Math.abs(deltaY);
                if (!(this.mNeedChangePosition || this.mNeedChangeVolume || this.mNeedChangeBrightness)) {
                    if (absDeltaX >= 80.0f) {
                        this.cancelUpdateProgressTimer();
                        this.mNeedChangePosition = true;
                        this.mGestureDownPosition = this.mIFsVideoPlayer.getCurrentPosition();
                    } else if (absDeltaY >= 80.0f) {
                        if (this.mDownX < (float)this.getWidth() * 0.5f) {
                            this.mNeedChangeBrightness = true;
                            this.mGestureDownBrightness = FsVideoUtils.scanForActivity((Context)this.mContext).getWindow().getAttributes().screenBrightness;
                        } else {
                            this.mNeedChangeVolume = true;
                            this.mGestureDownVolume = this.mIFsVideoPlayer.getVolume();
                        }
                    }
                }
                if (this.mNeedChangePosition) {
                    long duration = this.mIFsVideoPlayer.getDuration();
                    long toPosition = (long)((float)this.mGestureDownPosition + (float)duration * deltaX / (float)this.getWidth());
                    this.mNewPosition = Math.max(0L, Math.min(duration, toPosition));
                    int newPositionProgress = (int)(100.0f * (float)this.mNewPosition / (float)duration);
                    this.showChangePosition(duration, newPositionProgress);
                }
                if (this.mNeedChangeBrightness) {
                    deltaY = -deltaY;
                    float deltaBrightness = deltaY * 3.0f / (float)this.getHeight();
                    float newBrightness = this.mGestureDownBrightness + deltaBrightness;
                    float newBrightnessPercentage = newBrightness = Math.max(0.0f, Math.min(newBrightness, 1.0f));
                    WindowManager.LayoutParams params = FsVideoUtils.scanForActivity(this.mContext).getWindow().getAttributes();
                    params.screenBrightness = newBrightnessPercentage;
                    FsVideoUtils.scanForActivity(this.mContext).getWindow().setAttributes(params);
                    int newBrightnessProgress = (int)(100.0f * newBrightnessPercentage);
                    this.showChangeBrightness(newBrightnessProgress);
                }
                if (!this.mNeedChangeVolume) break;
                deltaY = -deltaY;
                int maxVolume = this.mIFsVideoPlayer.getMaxVolume();
                int deltaVolume = (int)((float)maxVolume * deltaY * 3.0f / (float)this.getHeight());
                int newVolume = this.mGestureDownVolume + deltaVolume;
                newVolume = Math.max(0, Math.min(maxVolume, newVolume));
                this.mIFsVideoPlayer.setVolume(newVolume);
                int newVolumeProgress = (int)(100.0f * (float)newVolume / (float)maxVolume);
                this.showChangeVolume(newVolumeProgress);
                break;
            }
            case 1: 
            case 3: {
                if (this.mNeedChangePosition) {
                    this.mIFsVideoPlayer.seekTo(this.mNewPosition);
                    this.hideChangePosition();
                    this.startUpdateProgressTimer();
                    return true;
                }
                if (this.mNeedChangeBrightness) {
                    this.hideChangeBrightness();
                    return true;
                }
                if (!this.mNeedChangeVolume) break;
                this.hideChangeVolume();
                return true;
            }
        }
        return false;
    }

    protected abstract void showChangeVolume(int var1);

    protected abstract void hideChangeVolume();

    protected abstract void showChangeBrightness(int var1);

    protected abstract void hideChangeBrightness();

    protected abstract void showChangePosition(long var1, int var3);

    protected abstract void hideChangePosition();

    public abstract void isAbleFullScreen(boolean var1);
}

