/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.framework.utils;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import cn.sharesdk.framework.utils.SSDKLog;
import com.mob.MobSDK;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ShareSDKFileProvider
extends ContentProvider {
    private static final String[] a = new String[]{"_display_name", "_size"};
    private static final File b = new File("/");
    private static HashMap<String, PathStrategy> c = new HashMap();
    private PathStrategy d;

    public boolean onCreate() {
        SSDKLog.b().d((Object)"ShareSDKFileProvider onCreate ", new Object[0]);
        return true;
    }

    public void attachInfo(Context context, ProviderInfo info) {
        super.attachInfo(context, info);
        if (info.exported) {
            SSDKLog.b().d((Object)"ShareSDKFileProvider attachInfo ===> Provider must not be exported", new Object[0]);
            throw new SecurityException("Provider must not be exported");
        }
        if (!info.grantUriPermissions) {
            SSDKLog.b().d((Object)"ShareSDKFileProvider attachInfo ===> Provider must grant uri permissions", new Object[0]);
            throw new SecurityException("Provider must grant uri permissions");
        }
        SSDKLog.b().d((Object)"ShareSDKFileProvider attachInfo ", new Object[0]);
        this.d = ShareSDKFileProvider.a(context, info.authority);
        SSDKLog.b().d((Object)("ShareSDKFileProvider attachInfo mStrategy===> " + this.d), new Object[0]);
    }

    public static Uri a(Context context, String string, File file) {
        PathStrategy pathStrategy = ShareSDKFileProvider.a(context, string);
        return pathStrategy.getUriForFile(file);
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        File file = this.d.getFileForUri(uri);
        if (projection == null) {
            projection = a;
        }
        String[] stringArray = new String[((String[])projection).length];
        Object[] objectArray = new Object[((String[])projection).length];
        int n2 = 0;
        for (String string : projection) {
            if ("_display_name".equals(string)) {
                stringArray[n2] = "_display_name";
                objectArray[n2++] = file.getName();
                continue;
            }
            if (!"_size".equals(string)) continue;
            stringArray[n2] = "_size";
            objectArray[n2++] = file.length();
        }
        stringArray = ShareSDKFileProvider.a(stringArray, n2);
        objectArray = ShareSDKFileProvider.a(objectArray, n2);
        MatrixCursor matrixCursor = new MatrixCursor(stringArray, 1);
        matrixCursor.addRow(objectArray);
        return matrixCursor;
    }

    public String getType(Uri uri) {
        File file = this.d.getFileForUri(uri);
        int n2 = file.getName().lastIndexOf(46);
        if (n2 >= 0) {
            String string = file.getName().substring(n2 + 1);
            String string2 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string);
            if (string2 != null) {
                return string2;
            }
        }
        return "application/octet-stream";
    }

    public Uri insert(Uri uri, ContentValues values) {
        throw new UnsupportedOperationException("No external inserts");
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("No external updates");
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        File file = this.d.getFileForUri(uri);
        return file.delete() ? 1 : 0;
    }

    public ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
        File file = this.d.getFileForUri(uri);
        int n2 = ShareSDKFileProvider.a(mode);
        return ParcelFileDescriptor.open((File)file, (int)n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PathStrategy a(Context context, String string) {
        PathStrategy pathStrategy;
        HashMap<String, PathStrategy> hashMap = c;
        synchronized (hashMap) {
            pathStrategy = c.get(string);
            if (pathStrategy == null) {
                pathStrategy = ShareSDKFileProvider.b(context, string);
                c.put(string, pathStrategy);
            }
        }
        SSDKLog.b().d((Object)("ShareSDKFileProvider getPathStrategy strat " + pathStrategy), new Object[0]);
        return pathStrategy;
    }

    private static PathStrategy b(Context context, String string) {
        a a2 = new a(string);
        String string2 = "imageNameFilesDir";
        String string3 = "Mob/cache/images";
        String string4 = "videoNameFilesDir";
        String string5 = "Mob/cache/videos";
        File file = null;
        file = context.getFilesDir();
        if (file != null) {
            a2.a(string2, ShareSDKFileProvider.a(file, string3));
            a2.a(string4, ShareSDKFileProvider.a(file, string5));
            SSDKLog.b().d((Object)("ShareSDKFileProvider target " + file), new Object[0]);
        }
        String string6 = "cachename";
        String string7 = ".";
        String string8 = "imageNameExternal";
        String string9 = "Mob/" + MobSDK.getContext().getPackageName() + "/cache/images";
        String string10 = "imageNameExternal";
        String string11 = "Mob/cache/images";
        File file2 = MobSDK.getContext().getCacheDir();
        if (file2 != null) {
            a2.a(string6, ShareSDKFileProvider.a(file, string7));
            a2.a(string8, ShareSDKFileProvider.a(file, string9));
            a2.a(string10, ShareSDKFileProvider.a(file, string11));
            SSDKLog.b().d((Object)("ShareSDKFileProvider target " + file2), new Object[0]);
        }
        String string12 = "imageNameExternal";
        String string13 = "Mob/" + MobSDK.getContext().getPackageName() + "/cache/images";
        String string14 = "videoNameExternal";
        String string15 = "Mob/" + MobSDK.getContext().getPackageName() + "/cache/videos";
        String string16 = "mihayou";
        String string17 = ".";
        String string18 = "more";
        String string19 = "./.";
        File file3 = null;
        File[] fileArray = ShareSDKFileProvider.a(MobSDK.getContext());
        if (fileArray.length > 0) {
            file3 = fileArray[0];
        }
        if (file3 != null) {
            a2.a(string12, ShareSDKFileProvider.a(file3, string13));
            a2.a(string14, ShareSDKFileProvider.a(file3, string15));
            a2.a(string16, ShareSDKFileProvider.a(file3, string17));
            a2.a(string18, ShareSDKFileProvider.a(file3, string19));
            SSDKLog.b().d((Object)("ShareSDKFileProvider target " + file3), new Object[0]);
        }
        String string20 = "imageNameEtc";
        String string21 = "Mob/" + MobSDK.getContext().getPackageName() + "/cache/images";
        String string22 = "videoNameEtc";
        String string23 = "Mob/" + MobSDK.getContext().getPackageName() + "/cache/videos";
        File file4 = null;
        File[] fileArray2 = ShareSDKFileProvider.b(MobSDK.getContext());
        if (fileArray2.length > 0) {
            file4 = fileArray2[0];
        }
        if (file4 != null) {
            a2.a(string20, ShareSDKFileProvider.a(file4, string21));
            a2.a(string22, ShareSDKFileProvider.a(file4, string23));
            SSDKLog.b().d((Object)("ShareSDKFileProvider target " + file4), new Object[0]);
        }
        String string24 = "imageNameRoot";
        String string25 = "Mob/cache/images";
        String string26 = "videoNameRoot";
        String string27 = "Mob/cache/videos";
        File file5 = null;
        file = b;
        if (file != null) {
            a2.a(string24, ShareSDKFileProvider.a(file5, string25));
            a2.a(string26, ShareSDKFileProvider.a(file5, string27));
        }
        String string28 = "externalStDir";
        String string29 = ".";
        File file6 = null;
        file6 = Environment.getExternalStorageDirectory();
        if (file6 != null) {
            a2.a(string28, ShareSDKFileProvider.a(file6, string29));
            SSDKLog.b().d((Object)("ShareSDKFileProvider target " + file6), new Object[0]);
        }
        SSDKLog.b().d((Object)("ShareSDKFileProvider !!! target===> " + file), new Object[0]);
        return a2;
    }

    public static File[] a(Context context) {
        if (Build.VERSION.SDK_INT >= 19) {
            SSDKLog.b().d((Object)"ShareSDKFileProvider api >= 19", new Object[0]);
            return context.getExternalFilesDirs(null);
        }
        SSDKLog.b().d((Object)"ShareSDKFileProvider api <= 19", new Object[0]);
        return new File[]{context.getExternalFilesDir(null)};
    }

    public static File[] b(Context context) {
        if (Build.VERSION.SDK_INT >= 19) {
            SSDKLog.b().d((Object)"ShareSDKFileProvider api >= 19", new Object[0]);
            return context.getExternalCacheDirs();
        }
        SSDKLog.b().d((Object)"ShareSDKFileProvider api <= 19", new Object[0]);
        return new File[]{context.getExternalCacheDir()};
    }

    private static int a(String string) {
        int n2;
        if ("r".equals(string)) {
            n2 = 0x10000000;
        } else if ("w".equals(string) || "wt".equals(string)) {
            n2 = 0x2C000000;
        } else if ("wa".equals(string)) {
            n2 = 0x2A000000;
        } else if ("rw".equals(string)) {
            n2 = 0x38000000;
        } else if ("rwt".equals(string)) {
            n2 = 0x3C000000;
        } else {
            throw new IllegalArgumentException("Invalid mode: " + string);
        }
        return n2;
    }

    private static File a(File file, String ... stringArray) {
        File file2 = file;
        for (String string : stringArray) {
            if (string == null) continue;
            file2 = new File(file2, string);
        }
        return file2;
    }

    private static String[] a(String[] stringArray, int n2) {
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        return stringArray2;
    }

    private static Object[] a(Object[] objectArray, int n2) {
        Object[] objectArray2 = new Object[n2];
        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        return objectArray2;
    }

    static class a
    implements PathStrategy {
        private final String a;
        private final HashMap<String, File> b = new HashMap();

        public a(String string) {
            this.a = string;
        }

        public void a(String string, File file) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new IllegalArgumentException("Name must not be empty");
            }
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Failed to resolve canonical path for " + file, iOException);
            }
            SSDKLog.b().d((Object)("ShareSDKFileProvider addRoot name ===> " + string + " root===> " + file), new Object[0]);
            this.b.put(string, file);
        }

        @Override
        public Uri getUriForFile(File file) {
            String string;
            try {
                SSDKLog.b().d((Object)("ShareSDKFileProvider !!! getUriForFile !!! file " + file), new Object[0]);
                string = file.getCanonicalPath();
                SSDKLog.b().d((Object)("ShareSDKFileProvider getUriForFile path " + string), new Object[0]);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Failed to resolve canonical path for " + file);
            }
            Map.Entry<String, File> entry = null;
            for (Map.Entry<String, File> entry2 : this.b.entrySet()) {
                String string2 = entry2.getValue().getPath();
                if (!string.startsWith(string2) || entry != null && string2.length() <= entry.getValue().getPath().length()) continue;
                entry = entry2;
                SSDKLog.b().d((Object)("ShareSDKFileProvider getUriForFile mostSpecific " + entry), new Object[0]);
            }
            if (entry == null) {
                SSDKLog.b().d((Object)("ShareSDKFileProvider Failed to find configured root that contains " + string), new Object[0]);
                throw new IllegalArgumentException("Failed to find configured root that contains " + string);
            }
            String string3 = ((File)entry.getValue()).getPath();
            string = string3.endsWith("/") ? string.substring(string3.length()) : string.substring(string3.length() + 1);
            string = Uri.encode((String)entry.getKey()) + '/' + Uri.encode((String)string, (String)"/");
            return new Uri.Builder().scheme("content").authority(this.a).encodedPath(string).build();
        }

        @Override
        public File getFileForUri(Uri uri) {
            String string = uri.getEncodedPath();
            int n2 = string.indexOf(47, 1);
            String string2 = Uri.decode((String)string.substring(1, n2));
            string = Uri.decode((String)string.substring(n2 + 1));
            File file = this.b.get(string2);
            if (file == null) {
                throw new IllegalArgumentException("Unable to find configured root for " + uri);
            }
            File file2 = new File(file, string);
            try {
                file2 = file2.getCanonicalFile();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Failed to resolve canonical path for " + file2);
            }
            if (!file2.getPath().startsWith(file.getPath())) {
                throw new SecurityException("Resolved path jumped beyond configured root");
            }
            return file2;
        }
    }

    static interface PathStrategy {
        public Uri getUriForFile(File var1);

        public File getFileForUri(Uri var1);
    }
}

