/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.framework;

import android.content.Context;
import cn.sharesdk.framework.Platform;
import cn.sharesdk.framework.ShareSDK;
import cn.sharesdk.framework.b.b.f;
import cn.sharesdk.framework.utils.SSDKLog;
import com.mob.MobSDK;
import com.mob.tools.utils.DeviceHelper;
import com.mob.tools.utils.Hashon;
import java.util.HashMap;

public abstract class Service {
    public String getDeviceKey() {
        return DeviceHelper.getInstance((Context)MobSDK.getContext()).getDeviceKey();
    }

    protected abstract int getServiceVersionInt();

    public abstract String getServiceVersionName();

    public void onBind() {
    }

    public void onUnbind() {
    }

    public static abstract class ServiceEvent {
        private static final int PLATFORM = 1;
        protected Service service;

        public ServiceEvent(Service service) {
            this.service = service;
        }

        protected HashMap<String, Object> toMap() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            DeviceHelper deviceHelper = DeviceHelper.getInstance((Context)MobSDK.getContext());
            hashMap.put("deviceid", deviceHelper.getDeviceKey());
            hashMap.put("appkey", MobSDK.getAppkey());
            hashMap.put("apppkg", deviceHelper.getPackageName());
            hashMap.put("appver", deviceHelper.getAppVersion());
            hashMap.put("sdkver", this.service.getServiceVersionInt());
            hashMap.put("plat", 1);
            hashMap.put("networktype", deviceHelper.getDetailNetworkTypeForStatic());
            hashMap.put("deviceData", deviceHelper.getDeviceDataNotAES());
            return hashMap;
        }

        public final String toString() {
            return new Hashon().fromHashMap(this.toMap());
        }

        protected HashMap<String, Object> filterShareContent(int platformId, Platform.ShareParams params, HashMap<String, Object> result) {
            String string = ShareSDK.platformIdToName(platformId);
            Platform platform = null;
            try {
                platform = ShareSDK.getPlatform(string);
            }
            catch (Throwable throwable) {
                SSDKLog.b().d((Object)("ShareSDK Service filterShareContent catch: " + throwable), new Object[0]);
            }
            if (platform == null) {
                return null;
            }
            f.a a2 = platform.filterShareContent(params, result);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("shareID", a2.a);
            hashMap.put("shareContent", new Hashon().fromJson(a2.toString()));
            SSDKLog.b().i((Object)"filterShareContent ==>>%s", new Object[]{hashMap});
            return hashMap;
        }
    }
}

