/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.onekeyshare.themes.classic.land;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import cn.sharesdk.onekeyshare.OnekeyShareThemeImpl;
import cn.sharesdk.onekeyshare.themes.classic.EditPage;
import cn.sharesdk.onekeyshare.themes.classic.XView;
import com.mob.tools.gui.AsyncImageView;
import com.mob.tools.utils.BitmapHelper;
import com.mob.tools.utils.ResHelper;
import java.io.File;

public class EditPageLand
extends EditPage
implements View.OnClickListener,
TextWatcher,
Runnable {
    private static final int DESIGN_SCREEN_WIDTH = 720;
    private static final int DESIGN_BOTTOM_HEIGHT = 75;
    private static final int DESIGN_LEFT_PADDING = 40;
    private static final int DESIGN_TITLE_HEIGHT_L = 70;
    private static final int DESIGN_THUMB_HEIGHT_L = 280;
    private static final int DESIGN_REMOVE_THUMB_HEIGHT_L = 60;

    public EditPageLand(OnekeyShareThemeImpl impl) {
        super(impl);
    }

    @Override
    public void onCreate() {
        super.onCreate();
        int screenHeight = ResHelper.getScreenHeight((Context)this.activity);
        float ratio = (float)screenHeight / 720.0f;
        this.maxBodyHeight = 0;
        this.llPage = new LinearLayout((Context)this.activity);
        this.llPage.setOrientation(1);
        this.activity.setContentView((View)this.llPage);
        this.rlTitle = new RelativeLayout((Context)this.activity);
        this.rlTitle.setBackgroundColor(-1644052);
        int titleHeight = (int)(70.0f * ratio);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, titleHeight);
        this.llPage.addView((View)this.rlTitle, (ViewGroup.LayoutParams)lp);
        this.initTitle(this.rlTitle, ratio);
        RelativeLayout rlBody = new RelativeLayout((Context)this.activity);
        rlBody.setBackgroundColor(-1);
        lp = new LinearLayout.LayoutParams(-1, -2);
        this.llPage.addView((View)rlBody, (ViewGroup.LayoutParams)lp);
        this.initBody(rlBody, ratio);
        LinearLayout llShadow = new LinearLayout((Context)this.activity);
        llShadow.setOrientation(1);
        rlBody.addView((View)llShadow, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
        this.initShadow(llShadow, ratio);
        this.llBottom = new LinearLayout((Context)this.activity);
        this.llBottom.setOrientation(1);
        lp = new LinearLayout.LayoutParams(-1, -2);
        this.llPage.addView((View)this.llBottom, (ViewGroup.LayoutParams)lp);
        this.initBottom(this.llBottom, ratio);
    }

    private void initTitle(RelativeLayout rlTitle, float ratio) {
        this.tvCancel = new TextView((Context)this.activity);
        this.tvCancel.setTextColor(-12895429);
        this.tvCancel.setTextSize(2, 18.0f);
        this.tvCancel.setGravity(17);
        int resId = ResHelper.getStringRes((Context)this.activity, (String)"ssdk_oks_cancel");
        if (resId > 0) {
            this.tvCancel.setText(resId);
        }
        int padding = (int)(40.0f * ratio);
        this.tvCancel.setPadding(padding, 0, padding, 0);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-2, -1);
        rlTitle.addView((View)this.tvCancel, (ViewGroup.LayoutParams)lp);
        this.tvCancel.setOnClickListener((View.OnClickListener)this);
        TextView tvTitle = new TextView((Context)this.activity);
        tvTitle.setTextColor(-12895429);
        tvTitle.setTextSize(2, 22.0f);
        tvTitle.setGravity(17);
        resId = ResHelper.getStringRes((Context)this.activity, (String)"ssdk_oks_multi_share");
        if (resId > 0) {
            tvTitle.setText(resId);
        }
        lp = new RelativeLayout.LayoutParams(-2, -1);
        lp.addRule(13);
        rlTitle.addView((View)tvTitle, (ViewGroup.LayoutParams)lp);
        this.tvShare = new TextView((Context)this.activity);
        this.tvShare.setTextColor(-37615);
        this.tvShare.setTextSize(2, 18.0f);
        this.tvShare.setGravity(17);
        resId = ResHelper.getStringRes((Context)this.activity, (String)"ssdk_oks_share");
        if (resId > 0) {
            this.tvShare.setText(resId);
        }
        this.tvShare.setPadding(padding, 0, padding, 0);
        lp = new RelativeLayout.LayoutParams(-2, -1);
        lp.addRule(11);
        rlTitle.addView((View)this.tvShare, (ViewGroup.LayoutParams)lp);
        this.tvShare.setOnClickListener((View.OnClickListener)this);
    }

    private void initBody(RelativeLayout rlBody, float ratio) {
        this.svContent = new ScrollView((Context)this.activity);
        rlBody.addView((View)this.svContent, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
        LinearLayout llContent = new LinearLayout((Context)this.activity);
        llContent.setOrientation(0);
        this.svContent.addView((View)llContent, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        this.etContent = new EditText((Context)this.activity);
        int padding = (int)(40.0f * ratio);
        this.etContent.setPadding(padding, padding, padding, padding);
        this.etContent.setBackgroundDrawable(null);
        this.etContent.setTextColor(-12895429);
        this.etContent.setTextSize(2, 21.0f);
        this.etContent.setText((CharSequence)this.sp.getText());
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(0, -2);
        lp.weight = 1.0f;
        llContent.addView((View)this.etContent, (ViewGroup.LayoutParams)lp);
        this.etContent.addTextChangedListener((TextWatcher)this);
        this.rlThumb = new RelativeLayout((Context)this.activity);
        this.rlThumb.setBackgroundColor(-13553359);
        int thumbWidth = (int)(280.0f * ratio);
        int xWidth = (int)(60.0f * ratio);
        lp = new LinearLayout.LayoutParams(thumbWidth, thumbWidth);
        lp.bottomMargin = lp.topMargin = padding;
        lp.rightMargin = lp.topMargin;
        llContent.addView((View)this.rlThumb, (ViewGroup.LayoutParams)lp);
        this.aivThumb = new AsyncImageView((Context)this.activity){

            public void onImageGot(String url, Bitmap bm) {
                EditPageLand.this.thumb = bm;
                super.onImageGot(url, bm);
            }
        };
        this.aivThumb.setScaleToCropCenter(true);
        RelativeLayout.LayoutParams rllp = new RelativeLayout.LayoutParams(thumbWidth, thumbWidth);
        this.rlThumb.addView((View)this.aivThumb, (ViewGroup.LayoutParams)rllp);
        this.aivThumb.setOnClickListener((View.OnClickListener)this);
        this.initThumb(this.aivThumb);
        this.xvRemove = new XView((Context)this.activity);
        this.xvRemove.setRatio(ratio);
        rllp = new RelativeLayout.LayoutParams(xWidth, xWidth);
        rllp.addRule(10);
        rllp.addRule(11);
        this.rlThumb.addView((View)this.xvRemove, (ViewGroup.LayoutParams)rllp);
        this.xvRemove.setOnClickListener(this);
    }

    private void initBottom(LinearLayout llBottom, float ratio) {
        LinearLayout llAt = new LinearLayout((Context)this.activity);
        llAt.setPadding(0, 0, 0, 5);
        llAt.setBackgroundColor(-1);
        int bottomHeight = (int)(75.0f * ratio);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, bottomHeight);
        llBottom.addView((View)llAt, (ViewGroup.LayoutParams)lp);
        this.tvAt = new TextView((Context)this.activity);
        this.tvAt.setTextColor(-12895429);
        this.tvAt.setTextSize(2, 21.0f);
        this.tvAt.setGravity(80);
        this.tvAt.setText((CharSequence)"@");
        int padding = (int)(40.0f * ratio);
        this.tvAt.setPadding(padding, 0, padding, 0);
        lp = new LinearLayout.LayoutParams(-2, -1);
        llAt.addView((View)this.tvAt, (ViewGroup.LayoutParams)lp);
        this.tvAt.setOnClickListener((View.OnClickListener)this);
        if (this.isShowAtUserLayout(this.platform.getName())) {
            this.tvAt.setVisibility(0);
        } else {
            this.tvAt.setVisibility(4);
        }
        this.tvTextCouter = new TextView((Context)this.activity);
        this.tvTextCouter.setTextColor(-12895429);
        this.tvTextCouter.setTextSize(2, 18.0f);
        this.tvTextCouter.setGravity(85);
        this.onTextChanged((CharSequence)this.etContent.getText(), 0, 0, 0);
        this.tvTextCouter.setPadding(padding, 0, padding, 0);
        lp = new LinearLayout.LayoutParams(-2, -1);
        lp.weight = 1.0f;
        llAt.addView((View)this.tvTextCouter, (ViewGroup.LayoutParams)lp);
        View v = new View((Context)this.activity);
        v.setBackgroundColor(-3355444);
        int px1 = ratio > 1.0f ? (int)ratio : 1;
        lp = new LinearLayout.LayoutParams(-1, px1);
        llBottom.addView(v, (ViewGroup.LayoutParams)lp);
    }

    private void initShadow(LinearLayout llShadow, float ratio) {
        int px1 = ratio > 1.0f ? (int)ratio : 1;
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, px1);
        View v = new View((Context)this.activity);
        v.setBackgroundColor(0x29000000);
        llShadow.addView(v, (ViewGroup.LayoutParams)lp);
        v = new View((Context)this.activity);
        v.setBackgroundColor(0x14000000);
        llShadow.addView(v, (ViewGroup.LayoutParams)lp);
        v = new View((Context)this.activity);
        v.setBackgroundColor(0x7000000);
        llShadow.addView(v, (ViewGroup.LayoutParams)lp);
    }

    private void initThumb(AsyncImageView aivThumb) {
        String imageUrl = this.sp.getImageUrl();
        String imagePath = this.sp.getImagePath();
        String[] imageArray = this.sp.getImageArray();
        Bitmap pic = null;
        this.rlThumb.setVisibility(0);
        if (!TextUtils.isEmpty((CharSequence)imagePath) && new File(imagePath).exists()) {
            try {
                pic = BitmapHelper.getBitmap((String)imagePath);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (pic != null) {
            this.thumb = pic;
            aivThumb.setBitmap(pic);
        } else if (imageArray != null && imageArray.length > 0 && !TextUtils.isEmpty((CharSequence)imageArray[0]) && new File(imageArray[0]).exists()) {
            try {
                pic = BitmapHelper.getBitmap((String)imagePath);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (pic != null) {
            this.thumb = pic;
            aivThumb.setBitmap(pic);
        } else if (pic == null && !TextUtils.isEmpty((CharSequence)imageUrl)) {
            aivThumb.execute(imageUrl, 0);
        } else {
            this.rlThumb.setVisibility(8);
        }
    }
}

