/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.onekeyshare.themes.classic;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.View;

public class IndicatorView
extends View {
    private static final int DESIGN_INDICATOR_RADIUS = 6;
    private static final int DESIGN_INDICATOR_DISTANCE = 14;
    private static final int DESIGN_BOTTOM_HEIGHT = 52;
    private int count;
    private int current;

    public IndicatorView(Context context) {
        super(context);
    }

    public void setScreenCount(int count) {
        this.count = count;
    }

    public void onScreenChange(int currentScreen, int lastScreen) {
        if (currentScreen != this.current) {
            this.current = currentScreen;
            this.postInvalidate();
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.count <= 1) {
            this.setVisibility(8);
            return;
        }
        float height = this.getHeight();
        float radius = height * 6.0f / 52.0f;
        float distance = height * 14.0f / 52.0f;
        float windowWidth = radius * 2.0f * (float)this.count + distance * (float)(this.count - 1);
        float left = ((float)this.getWidth() - windowWidth) / 2.0f;
        float cy = height / 2.0f;
        canvas.drawColor(-1);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        for (int i = 0; i < this.count; ++i) {
            if (i == this.current) {
                paint.setColor(-10653280);
            } else {
                paint.setColor(-5262921);
            }
            float cx = left + (radius * 2.0f + distance) * (float)i;
            canvas.drawCircle(cx, cy, radius, paint);
        }
    }
}

