/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.onekeyshare.themes.classic;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import cn.sharesdk.framework.Platform;
import cn.sharesdk.framework.ShareSDK;
import cn.sharesdk.onekeyshare.OnekeySharePage;
import cn.sharesdk.onekeyshare.OnekeyShareThemeImpl;
import cn.sharesdk.onekeyshare.themes.classic.FriendListPage;
import cn.sharesdk.onekeyshare.themes.classic.PicViewerPage;
import cn.sharesdk.onekeyshare.themes.classic.XView;
import cn.sharesdk.onekeyshare.themes.classic.land.FriendListPageLand;
import cn.sharesdk.onekeyshare.themes.classic.port.FriendListPagePort;
import com.mob.MobSDK;
import com.mob.tools.gui.AsyncImageView;
import com.mob.tools.utils.DeviceHelper;
import com.mob.tools.utils.ReflectHelper;
import com.mob.tools.utils.ResHelper;
import java.util.ArrayList;
import java.util.HashMap;

public class EditPage
extends OnekeySharePage
implements View.OnClickListener,
TextWatcher,
Runnable {
    private OnekeyShareThemeImpl impl;
    protected Platform platform;
    protected Platform.ShareParams sp;
    protected LinearLayout llPage;
    protected RelativeLayout rlTitle;
    protected ScrollView svContent;
    protected EditText etContent;
    protected TextView tvCancel;
    protected TextView tvShare;
    protected RelativeLayout rlThumb;
    protected AsyncImageView aivThumb;
    protected XView xvRemove;
    protected LinearLayout llBottom;
    protected TextView tvAt;
    protected TextView tvTextCouter;
    protected Bitmap thumb;
    protected int maxBodyHeight;

    public EditPage(OnekeyShareThemeImpl impl) {
        super(impl);
        this.impl = impl;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public void setShareParams(Platform.ShareParams sp) {
        this.sp = sp;
    }

    protected int onSetTheme(int resid, boolean atLaunch) {
        if (this.isDialogMode()) {
            this.activity.requestWindowFeature(1);
            if (Build.VERSION.SDK_INT >= 11) {
                try {
                    ReflectHelper.invokeInstanceMethod((Object)this.activity, (String)"setFinishOnTouchOutside", (Object[])new Object[]{false});
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return 16973835;
        }
        this.activity.getWindow().setSoftInputMode(37);
        return super.onSetTheme(resid, atLaunch);
    }

    public void onCreate() {
        this.activity.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(-789517));
    }

    private void cancelAndFinish() {
        ShareSDK.logDemoEvent((int)5, (Platform)this.platform);
        this.finish();
    }

    private void shareAndFinish() {
        int resId = ResHelper.getStringRes((Context)this.activity, (String)"ssdk_oks_sharing");
        if (resId > 0) {
            Toast.makeText((Context)this.activity, (int)resId, (int)0).show();
        }
        if (this.isDisableSSO()) {
            this.platform.SSOSetting(true);
        }
        this.platform.setPlatformActionListener(this.getCallback());
        this.platform.share(this.sp);
        this.impl.callback = null;
        this.finish();
    }

    private void showThumb(Bitmap pic) {
        PicViewerPage page = new PicViewerPage(this.impl);
        page.setImageBitmap(pic);
        page.show((Context)this.activity, null);
    }

    private void removeThumb() {
        this.sp.setImageArray(null);
        this.sp.setImageData(null);
        this.sp.setImagePath(null);
        this.sp.setImageUrl(null);
    }

    private void showFriendList() {
        int orientation = this.activity.getResources().getConfiguration().orientation;
        FriendListPage page = orientation == 1 ? new FriendListPagePort(this.impl) : new FriendListPageLand(this.impl);
        page.setPlatform(this.platform);
        page.showForResult(MobSDK.getContext(), null, this);
    }

    public void onResult(HashMap<String, Object> data) {
        String atText = this.getJoinSelectedUser(data);
        if (!TextUtils.isEmpty((CharSequence)atText)) {
            this.etContent.append((CharSequence)atText);
        }
    }

    private String getJoinSelectedUser(HashMap<String, Object> data) {
        if (data != null && data.containsKey("selected")) {
            ArrayList selected = (ArrayList)data.get("selected");
            String platform = ((Platform)data.get("platform")).getName();
            if ("FacebookMessenger".equals(platform)) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (String sel : selected) {
                sb.append('@').append(sel).append(' ');
            }
            return sb.toString();
        }
        return null;
    }

    protected boolean isShowAtUserLayout(String platformName) {
        return "SinaWeibo".equals(platformName) || "TencentWeibo".equals(platformName) || "Facebook".equals(platformName) || "Twitter".equals(platformName);
    }

    public void onClick(View v) {
        if (v.equals(this.tvCancel)) {
            this.cancelAndFinish();
        } else if (v.equals(this.tvShare)) {
            this.sp.setText(this.etContent.getText().toString().trim());
            this.shareAndFinish();
        } else if (v.equals(this.aivThumb)) {
            this.showThumb(this.thumb);
        } else if (v.equals((Object)this.xvRemove)) {
            this.maxBodyHeight = 0;
            this.rlThumb.setVisibility(8);
            this.llPage.measure(0, 0);
            this.onTextChanged((CharSequence)this.etContent.getText(), 0, 0, 0);
            this.removeThumb();
        } else if (v.equals(this.tvAt)) {
            this.showFriendList();
        }
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        this.tvTextCouter.setText((CharSequence)String.valueOf(s.length()));
        if (this.maxBodyHeight == 0) {
            this.maxBodyHeight = this.llPage.getHeight() - this.rlTitle.getHeight() - this.llBottom.getHeight();
        }
        if (this.maxBodyHeight > 0) {
            this.svContent.post((Runnable)this);
        }
    }

    @Override
    public void run() {
        int height = this.svContent.getChildAt(0).getHeight();
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)ResHelper.forceCast((Object)this.svContent.getLayoutParams());
        if (height > this.maxBodyHeight && lp.height != this.maxBodyHeight) {
            lp.height = this.maxBodyHeight;
            this.svContent.setLayoutParams((ViewGroup.LayoutParams)lp);
        } else if (height < this.maxBodyHeight && lp.height == this.maxBodyHeight) {
            lp.height = -2;
            this.svContent.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
    }

    public void afterTextChanged(Editable s) {
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onPause() {
        DeviceHelper.getInstance((Context)this.activity).hideSoftInput(this.getContentView());
        super.onPause();
    }
}

